"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstantExpiration = exports.MaxSigDeadline = exports.MaxUnorderedNonce = exports.MaxSignatureTransferAmount = exports.MaxOrderedNonce = exports.MaxAllowanceExpiration = exports.MaxAllowanceTransferAmount = exports.MaxUint256 = exports.MaxUint160 = exports.MaxUint48 = exports.permit2Address = exports.PERMIT2_ADDRESS = void 0;
const bignumber_1 = require("@ethersproject/bignumber");
// @deprecated please use permit2Address(chainId: number)
exports.PERMIT2_ADDRESS = '0x000000000022D473030F116dDEE9F6B43aC78BA3';
function permit2Address(chainId) {
    switch (chainId) {
        case 324:
            return '0x0000000000225e31D15943971F47aD3022F714Fa';
        default:
            return exports.PERMIT2_ADDRESS;
    }
}
exports.permit2Address = permit2Address;
exports.MaxUint48 = bignumber_1.BigNumber.from('0xffffffffffff');
exports.MaxUint160 = bignumber_1.BigNumber.from('0xffffffffffffffffffffffffffffffffffffffff');
exports.MaxUint256 = bignumber_1.BigNumber.from('0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff');
// alias max types for their usages
// allowance transfer types
exports.MaxAllowanceTransferAmount = exports.MaxUint160;
exports.MaxAllowanceExpiration = exports.MaxUint48;
exports.MaxOrderedNonce = exports.MaxUint48;
// signature transfer types
exports.MaxSignatureTransferAmount = exports.MaxUint256;
exports.MaxUnorderedNonce = exports.MaxUint256;
exports.MaxSigDeadline = exports.MaxUint256;
exports.InstantExpiration = bignumber_1.BigNumber.from(0);
//# sourceMappingURL=constants.js.map